#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../helper/calendar_picker'

describe '[Story#VAR-1580: Calendar picker (Non-functional story)]' do
  include DriverUtility
  include OracleUtility
  include DateUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_request = NewAppointmentRequest.new(@driver)
    @error = Error_Validation.new(@driver)
    @calendar = CalendarPicker.new(@driver)

    APPOINTMENTS = "Appointments/Requests"

    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @threeMonthAgo = getDateNthMonthsFromNow(-3, "%m/%d/%Y")
    @yesterday = getDateNthDaysFromNow(-1,"%m/%d/%Y")
    @fiveDaysLater = getDateNthDaysFromNow(5, "%m/%d/%Y")

    deletePatientData("D123401")

  end

  after(:all) do
    @driver.close
  end

  context "AC: Implement Calendar Date Picker for Date Fields" do
    xit ". A calendar picker control is available for date entry fields " do
      @common.loginEndsOnHome(pw_redacted)

      @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
      expect(@landing_appointments.primary_header).to eq(APPOINTMENTS)

      @common.waitWhileSpinnerPresent

      Watir::Wait.until {@landing_appointments.add_top_btn_element.present?}
      @landing_appointments.add_top_btn_element.when_present

      @landing_appointments.add_top_btn
      @common.waitWhileSpinnerPresent
      expect(@new_request.has_expected_title?).to eq(true)

      Watir::Wait.until { @new_request.facility_radio_elements[1].present? }

      @new_request.select_facility_radio("650")
      @common.waitWhileSpinnerPresent
      @new_request.type_of_care = "PRIMARY CARE"
      @common.waitWhileSpinnerPresent

      @new_request.scheduling_method_radio_elements[1].when_visible(TIME_OUT_LIMIT)
      expect(@new_request.scheduling_method_radio_elements[1].enabled?).to eq(true)
      @new_request.select_scheduling_method_radio("clerk")

      #calendar control visible
      @new_request.option_date1_element.when_present(TIME_OUT_LIMIT)
      expect(@new_request.option_date_calendar1_element.present?).to eq(true)

    end

    xit ". When a user selects the calendar picker, a calendar view appears. " do
      @new_request.option_date_calendar1_element.click
      expect(@calendar.isCalendarDisplayed).to eq(true)
    end

    xit ". When the calendar picker is selected, the calendar opens inside the active screen or modal, keeping the originating screen in view." do
      #manual testing
    end


    xit ". Users can advance the calendar picker one month at a time within the available date range constraints." do
      #selected date is five days later
      expect(getMonthOfYear(@fiveDaysLater, "%B") +  " " + getYear(@fiveDaysLater)).to eq(@calendar.getTitleToggleButtonText)

      nextMonthAndYear = getNthMonthFromGivenDate(@fiveDaysLater, 1)

      @calendar.clickNextButton
      Watir::Wait.until {nextMonthAndYear == @calendar.getTitleToggleButtonText}
      expect(@calendar.getTitleToggleButtonText).to eq(nextMonthAndYear)

      nextMonthAndYear = getNthMonthFromGivenDate(@fiveDaysLater, 2)
      @calendar.clickNextButton
      Watir::Wait.until {nextMonthAndYear == @calendar.getTitleToggleButtonText}
      expect(@calendar.getTitleToggleButtonText).to eq(nextMonthAndYear)

      previousMonthAndYear = getNthMonthFromGivenDate(@fiveDaysLater, 1)
      @calendar.clickPreviousButton
      Watir::Wait.until {previousMonthAndYear == @calendar.getTitleToggleButtonText}
      expect(@calendar.getTitleToggleButtonText).to eq(previousMonthAndYear)

      previousMonthAndYear = getNthMonthFromGivenDate(@fiveDaysLater, 0)
      @calendar.clickPreviousButton
      Watir::Wait.until {previousMonthAndYear == @calendar.getTitleToggleButtonText}
      expect(@calendar.getTitleToggleButtonText).to eq(previousMonthAndYear)

    end

    xit ". Users can advance the calendar picker one year at a time within the available date range constraints." do
      #click Header button
      @calendar.clickTitleToggleButton
      year = @calendar.getTitleToggleButtonText

      Watir::Wait.until {getYear(@today) == year}
      expect(@calendar.getTitleToggleButtonText).to eq(getYear(@fiveDaysLater))

      MonthAfter90Days = getMonthOfYear(getDateNthDaysFromNow(90, "%m/%d/%Y"), "%B")
      MonthAfter130Days = getMonthOfYear(getDateNthDaysFromNow(130, "%m/%d/%Y"), "%B")

      #expect(@calendar.isMonthOrYearEnabled(MonthAfter90Days[0..2])).to eq(true)
      #expect(@calendar.isMonthOrYearEnabled(MonthAfter130Days[0..2])).to eq(false)

      #if month is enabled, then the next button is disabled
      #if(@calendar.isMonthOrYearEnabled(MonthAfter90Days[0..2]))
      #  expect(@calendar.isNextButtonVisible).to eq(false)
      #else
      #  expect(@calendar.isNextButtonVisible).to eq(true)
      #end

      expect(@calendar.areAllMonthsDisplayed).to eq(true)
    end


    xit ".  Users can select a day on the calendar." do
      #move to calendar view
      month = getMonthOfYear(@fiveDaysLater, "%b")
      @calendar.pickMonth(month)
      Watir::Wait.until {getMonthOfYear(@fiveDaysLater, "%B") +  " " + getYear(@fiveDaysLater) == @calendar.getTitleToggleButtonText}
      expect(getMonthOfYear(@fiveDaysLater, "%B") +  " " + getYear(@fiveDaysLater)).to eq(@calendar.getTitleToggleButtonText)

      twentyDaysLater = getDateNthDaysFromNow(20, "%m/%d/%Y")
      puts "Twenty days later is "  + twentyDaysLater.to_s

      if (getMonthOfYear(@fiveDaysLater, "%b") != getMonthOfYear(twentyDaysLater, "%b") )
        nextMonthAndYear = getNthMonthFromGivenDate(@fiveDaysLater, 1)
        @calendar.clickNextButton
        Watir::Wait.until {nextMonthAndYear == @calendar.getTitleToggleButtonText}
        expect(@calendar.getTitleToggleButtonText).to eq(nextMonthAndYear)
      end

      dayStr = getDay(twentyDaysLater)
      puts "Day String: " + dayStr.to_s
      @calendar.pickDay(dayStr)
      Watir::Wait.until {@new_request.option_date1 == twentyDaysLater}
      expect(@new_request.option_date1).to eq(twentyDaysLater)

      @new_request.option_date1_element.click
      @new_request.option_date_calendar1_element.click
      expect(@calendar.isCalendarDisplayed).to eq(true)
      fortyDaysLater = getDateNthDaysFromNow(40,"%m/%d/%Y")
      @calendar.pick(fortyDaysLater)
      Watir::Wait.until {@new_request.option_date1 == fortyDaysLater}
      expect(@new_request.option_date1).to eq(fortyDaysLater)

      @new_request.option_date2_element.click
      @new_request.option_date_calendar2_element.click
      expect(@calendar.isCalendarDisplayed).to eq(true)
      thirtyTwoDaysLater = getDateNthDaysFromNow(32,"%m/%d/%Y")
      @calendar.pick(thirtyTwoDaysLater)
      Watir::Wait.until {@new_request.option_date2 == thirtyTwoDaysLater}
      expect(@new_request.option_date2).to eq(thirtyTwoDaysLater)

    end

    xit ". Text box entries and calendar picker entries are kept in synch" do
      #click other element to close the calendar.
      @new_request.option_date1_element.click

      thirtyTwoDaysLater = getDateNthDaysFromNow(32,"%m/%d/%Y")

      @new_request.option_date_calendar2_element.click
      expect(@calendar.isCalendarDisplayed).to eq(true)
      @new_request.option_date2 = thirtyTwoDaysLater
      @new_request.option_date_calendar2_element.click
      expect(@calendar.isCalendarDisplayed).to eq(true)

      expect(@calendar.getcurrentYear()).to eq(getYear(thirtyTwoDaysLater))
      expect(@calendar.getCurrentMonth).to eq(getMonthOfYear(thirtyTwoDaysLater, "%B"))

      puts "current date "  + @calendar.getCurrentDay
      puts "getday " + getDay(thirtyTwoDaysLater)
      expect(@calendar.getCurrentDay()).to eq(getDay(thirtyTwoDaysLater))
    end

    xit ". This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open calendar control." do
      expect(@new_request.option_date_calendar1_element.attribute("aria-label")).to eq("This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open calendar control.")
      expect(@new_request.option_date_calendar2_element.attribute("aria-label")).to eq("This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open calendar control.")
      expect(@new_request.option_date_calendar3_element.attribute("aria-label")).to eq("This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open calendar control.")
    end

    xit ". To ensure an equivalent experience, the day associated with the selected date shall be made available to voice over users as a text element shown below the date text entry field." do
      #make sure day of the week populated for option date3 .. clicking other element
      @new_request.option_date2_element.click

      thirtyTwoDaysLater = getDateNthDaysFromNow(32, "%m/%d/%Y")
      expect(@new_request.optionDate2_day.split("\n")[1]).to eq(getDayofWeek(thirtyTwoDaysLater))
      puts "Day of the week " + @new_request.optionDate2_day

    end

    xit ". Date range constraints can be applied to the calendar picker so that excluded date values are not selectable." do
      @new_request.option_date3_element.click
      @new_request.option_date_calendar3_element.click
      expect(@calendar.isCalendarDisplayed).to eq(true)
      eightyNineDaysLater = getDateNthDaysFromNow(89,"%m/%d/%Y")
      @calendar.pick(eightyNineDaysLater)
      Watir::Wait.until {@new_request.option_date3 == eightyNineDaysLater}
      expect(@new_request.option_date3).to eq(eightyNineDaysLater)

      @new_request.option_date3 = ""
      @new_request.option_date3_element.click
      @new_request.option_date_calendar3_element.click
      expect(@calendar.isCalendarDisplayed).to eq(true)
      tomorrow = getDateNthDaysFromNow(1,"%m/%d/%Y")

      @calendar.flipToYear(getYear(tomorrow))
      if(@calendar.isMonthOrYearEnabled(getMonthOfYear(tomorrow, "%b")))
        @calendar.pickMonth(getMonthOfYear(tomorrow, "%b"))
        expect(@calendar.isDayEnabled(getDay(tomorrow))).to eq(false)
      else
        expect(@calendar.isMonthOrYearEnabled(getMonthOfYear(tomorrow, "%b"))).to eq(false)
        @calendar.pickMonth(getMonthOfYear(@fiveDaysLater, "%b"))
      end

      expect(@new_request.option_date3).to eq("")

      fourDaysLater = getDateNthDaysFromNow(4,"%m/%d/%Y")
      @calendar.flipToYear(getYear(fourDaysLater))
      if(@calendar.isMonthOrYearEnabled(getMonthOfYear(fourDaysLater, "%b")))
        @calendar.pickMonth(getMonthOfYear(fourDaysLater, "%b"))
        expect(@calendar.isDayEnabled(getDay(fourDaysLater))).to eq(false)
      else
        expect(@calendar.isMonthOrYearEnabled(getMonthOfYear(fourDaysLater, "%b"))).to eq(false)
        @calendar.pickMonth(getMonthOfYear(@fiveDaysLater, "%b"))
      end

      expect(@new_request.option_date3).to eq("")

      fiveDaysLater =getDateNthDaysFromNow(5,"%m/%d/%Y")
      @calendar.pick(fiveDaysLater)
      expect(@new_request.option_date3).to eq(fiveDaysLater)

      @new_request.option_date3 = ""
      @new_request.option_date_calendar3_element.click

      eightNineDaysLater =getDateNthDaysFromNow(89,"%m/%d/%Y")
      @calendar.pick(eightNineDaysLater)
     # expect(@calendar.isDayEnabled(getDay(eightNineDaysLater))).to eq(true)
      expect(@new_request.option_date3).to eq(eightNineDaysLater)

      @new_request.option_date3 = ""
      @new_request.option_date_calendar3_element.click

      ninetyOneDaysLater =getDateNthDaysFromNow(91,"%m/%d/%Y")
      @calendar.flipToYear(getYear(ninetyOneDaysLater))
      if(@calendar.isMonthOrYearEnabled(getMonthOfYear(ninetyOneDaysLater, "%b")))
        @calendar.pickMonth(getMonthOfYear(ninetyOneDaysLater, "%b"))
        expect(@calendar.isDayEnabled(getDay(ninetyOneDaysLater))).to eq(false)
      else
        expect(@calendar.isMonthOrYearEnabled(getMonthOfYear(ninetyOneDaysLater, "%b"))).to eq(false)
        @calendar.pickMonth(getMonthOfYear(@fiveDaysLater, "%b"))
      end

      expect(@new_request.option_date3).to eq("")
    end


  end
end
